cd "D:\硕士工作\气候金融\工作一 大宗商品与气候感知\投稿\金融研究\数据"

//选择数据
import delimited "金属市场.csv",clear

encode id ,gen(newid)

//请保证原始数据时间格式为yyyy/mm/dd,如2020/01/01
encode day ,gen(newtime)

xtset newid newtime	

rename temp Ab_Temp

//########异常温度-->收益率########
gen lnprice=log(price)*100
gen RET=d.lnprice

winsor2 RET,replace cut(1,99) by(newid)

pvarsoc  Ab_Temp RET, maxlag(4)

pvar2 Ab_Temp RET, lags(2) noprint
estimate store estpvar

pvarirf, oirf porder(Ab_Temp RET) iter(200) dots step(8)

//########异常温度-->波动率########
rename vol VOL
winsor2 VOL, replace cut(0,99) by(newid)

pvarsoc Ab_Temp  VOL,maxlag(4) 

pvar2 Ab_Temp  VOL, lags(1)
estimates store estpvar

pvarirf, oirf porder(Ab_Temp  VOL) iter(200) dots step(8)


//########异常温度-->不确定性########
gen DUNC=d.unc*100
winsor2 DUNC, replace cut(0,99) by(newid)

pvarsoc Ab_Temp DUNC,maxlag(4)

pvar2 Ab_Temp DUNC,lag(1)
estimates store estpvar

pvarirf, oirf porder(Ab_Temp DUNC) iter(200) dots step(8)


